%% Peridogram
% Martin H. Trauth 10 June 2021
%
% We first clear the workspace and the command window. We then close all
% figure windows.
clear, clc, close all

%%
% We then define the noise level, i.e. the standard deviation of the
% Gaussian noise Ns, the sampling frequency Fs and create a time vector t.
Ns = 2;
Fs = 2;
t = 1/Fs : 1/Fs : 500; t = t';

%%
% We then create a composite signal of multiple sine waves with different
% periods T, different amplitudes A and without noise.
rng(0)
x =  2*sin(2*pi*t/50) + ...
        sin(2*pi*t/15) + ...
    0.5*sin(2*pi*t/5);

figure('Position',[100 800 800 400],...
    'Color',[1 1 1])
axes('XLim',[0 100],...
    'XGrid','On',...
    'YGrid','On'), hold on
line(t,x,...
    'LineWidth',1)

%%
% We can use the Fast Fourier Transformation to calculate a Fourier
% spectrum of the signal, displayed as the power spectral density against
% the frequency f and the period T.
nfft = 2^nextpow2(length(t));
Xxx = fft(x,nfft);
Pxx2 = abs(Xxx).^2 /Fs /length(x);
Pxx = [Pxx2(1); 2*Pxx2(2:nfft/2)];
f = 0 : Fs/(nfft-1) : Fs/2;  f = f';

figure('Position',[100 700 800 400],...
    'Color',[1 1 1])
axes('XLim',[0 Fs/2],...
    'YLim',[0 max(Pxx)],...
    'XGrid','On',...
    'YGrid','On'), hold on
line(f,Pxx,...
    'LineWidth',1)
xlabel('Frequency')
ylabel('Power Spectral Density')

%%
% We can use the periodogram function of MATLAB to calculate a Fourier
% spectrum of the signal, displayed as the power spectral density against
% the frequency f and the period T.
[Pxx,f] = periodogram(x,[],length(t),Fs);

figure('Position',[100 600 800 400],...
    'Color',[1 1 1])
axes('XLim',[0 Fs/2],...
    'YLim',[0 max(Pxx)],...
    'XGrid','On',...
    'YGrid','On'), hold on
line(f,Pxx,...
    'LineWidth',1)
xlabel('Frequency')
ylabel('Power Spectral Density')

%%
% We then create a composite signal of multiple sine waves with different
% periods T, different amplitudes A and additive Gaussian noise Ns.
rng(0)
xn =  2*sin(2*pi*t/50) + ...
        sin(2*pi*t/15) + ...
    0.5*sin(2*pi*t/5) + ...
     Ns*randn(size(t));

figure('Position',[100 500 800 400],...
    'Color',[1 1 1])
axes('XLim',[0 100],...
    'XGrid','On',...
    'YGrid','On'), hold on
line(t,xn,...
    'LineWidth',1)

%%
% We can use the periodogram function of MATLAB to calculate a Fourier
% spectrum of the signal, displayed as the power spectral density against
% the frequency f and the period T.
[Pxx,f] = periodogram(xn,[],length(t),Fs);

figure('Position',[100 400 800 400],...
    'Color',[1 1 1])
axes('XLim',[0 Fs/2],...
    'YLim',[0 max(Pxx)],...
    'XGrid','On',...
    'YGrid','On'), hold on
line(f,Pxx,...
    'LineWidth',1)
xlabel('Frequency')
ylabel('Power Spectral Density')












